/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.toolkit.designer.properties.resourcestab;

import filenet.sim.api.VWScenarioDefinition;
import filenet.sim.api.VWScenarioResourceDefinition;
import filenet.sim.toolkit.designer.properties.VWSIMPropertyData;
import filenet.sim.toolkit.designer.properties.resources.VWSIMResource;
import filenet.sim.toolkit.utils.VWSIMHelp;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.VWAddRemovePanel;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;

class VWSIMResourceSelectionDialog
extends VWModalDialog
implements ActionListener {
    private VWAddRemovePanel m_addRemovePanel = null;
    private JButton m_okButton = null;
    private JButton m_cancelButton = null;
    private JButton m_helpButton = null;
    private VWSIMPropertyData m_propertyData = null;

    public VWSIMResourceSelectionDialog(VWSIMPropertyData propertyData) {
        super(propertyData.getParentFrame());
        this.m_propertyData = propertyData;
        this.setTitle(VWSIMResource.s_resourceSelectionDialogTitle);
        Dimension dim = VWStringUtils.stringToDimension(VWSIMResource.s_resourceSelectionDialogDim);
        if (dim == null) {
            dim = new Dimension(475, 275);
        }
        this.setSize(dim);
        this.createControls();
    }

    public void initialize(String[] selectedResourceNames) {
        if (this.m_addRemovePanel != null) {
            VWScenarioResourceDefinition[] resourceDefs;
            VWScenarioDefinition scenarioDef;
            String[] availableResourceNames = null;
            if (this.m_propertyData != null && (scenarioDef = this.m_propertyData.getScenarioDefinition()) != null && (resourceDefs = scenarioDef.getResources()) != null) {
                availableResourceNames = new String[resourceDefs.length];
                for (int i = 0; i < resourceDefs.length; ++i) {
                    availableResourceNames[i] = resourceDefs[i].getName();
                }
            }
            this.m_addRemovePanel.initializeLists(availableResourceNames, selectedResourceNames);
        }
    }

    public String[] getSelectedResourceNames() {
        if (this.m_addRemovePanel != null) {
            return this.m_addRemovePanel.getSelectedStringItems();
        }
        return null;
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source.equals(this.m_okButton)) {
            this.m_nExitStatus = 0;
            this.setVisible(false);
        } else if (source.equals(this.m_cancelButton)) {
            this.m_nExitStatus = 1;
            this.setVisible(false);
        } else if (source.equals(this.m_helpButton)) {
            VWSIMHelp.displayPage(VWSIMHelp.Help_Simulation_Designer + "resourceselectiondialog.htm");
        }
    }

    private void createControls() {
        JPanel panel;
        this.getContentPane().setLayout(new BorderLayout(4, 4));
        this.m_addRemovePanel = new VWAddRemovePanel(3850);
        if (this.m_addRemovePanel != null) {
            this.m_addRemovePanel.setAvailableItemName(VWSIMResource.s_availableResources);
            this.m_addRemovePanel.setSelectedItemName(VWSIMResource.s_selectedResources);
            this.getContentPane().add((Component)this.m_addRemovePanel, "Center");
        }
        if ((panel = this.createButtonPanel()) != null) {
            this.getContentPane().add((Component)panel, "Last");
        }
    }

    private JPanel createButtonPanel() {
        try {
            JPanel buttonPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.anchor = 10;
            gbCons.gridwidth = 1;
            gbCons.gridheight = 1;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(6, 6, 6, 6);
            this.m_okButton = new JButton(VWSIMResource.s_ok);
            this.m_okButton.addActionListener(this);
            buttonPanel.add((Component)this.m_okButton, gbCons);
            ++gbCons.gridx;
            this.m_cancelButton = new JButton(VWSIMResource.s_cancel);
            this.m_cancelButton.addActionListener(this);
            buttonPanel.add((Component)this.m_cancelButton, gbCons);
            ++gbCons.gridx;
            this.m_helpButton = new JButton(VWSIMResource.s_helpDots);
            this.m_helpButton.addActionListener(this);
            buttonPanel.add((Component)this.m_helpButton, gbCons);
            return buttonPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }
}

